﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using BMS.ServiceContracts;
using BMS.DataContracts;
using BMS.Utils;
using System.ServiceModel;

namespace BMS.ServicesWrapper.Proxy
{
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface IBedManagerCacheChannel : IBedManagerCache, IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class BedManagerCacheClient : ClientBase<IBedManagerCache>, IBedManagerCache, System.IDisposable
    {
        #region ProxyTool Generated Code

        private BedManagerCacheClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;



        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new BedManagerCacheClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new BedManagerCacheClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new BedManagerCacheClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new BedManagerCacheClient(_endpointConfigurationName);
                else
                    _instance = new BedManagerCacheClient();                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        
        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((ClientBase<IBedManagerCache>)_instance).Close();
                    if (_instance != this)
                        ((ClientBase<IBedManagerCache>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((ClientBase<IBedManagerCache>)_instance).Abort();
                    if (_instance != this)
                        ((ClientBase<IBedManagerCache>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion
        
        public BedManagerCacheClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerCacheClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerCacheClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerCacheClient(string endpointConfigurationName, EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerCacheClient(System.ServiceModel.Channels.Binding binding, EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertWebClientAddress(string url)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertWebClientAddress(url);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertWebClientAddress(url);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerCacheClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<string> GetWebClientAddresses()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetWebClientAddresses();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetWebClientAddresses();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerCacheClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public void UpdateEISCache(II id, string entityType)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateEISCache(id, entityType);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateEISCache(id, entityType);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerCacheClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void RemoveEISCache(II id, string entityType)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.RemoveEISCache(id, entityType);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.RemoveEISCache(id, entityType);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerCacheClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateEVSCache(string code, string vocabularyDomain)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateEVSCache(code, vocabularyDomain);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateEVSCache(code, vocabularyDomain);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerCacheClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void RemoveEVSCache(string code, string vocabularyDomain)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.RemoveEVSCache(code, vocabularyDomain);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.RemoveEVSCache(code, vocabularyDomain);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerCacheClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }        

        public void ClearUserPermissionCache(string userName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.ClearUserPermissionCache(userName);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.ClearUserPermissionCache(userName);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerCacheClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        } 

        public void UpdatePoliciesForOrganizationsCache()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdatePoliciesForOrganizationsCache();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdatePoliciesForOrganizationsCache();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerCacheClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }        

        public void UpdateUserRolesCache(InfoWorld.Security.Authorization.PolicyAdministrationPoint.User user)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateUserRolesCache(user);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateUserRolesCache(user);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerCacheClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateUserRolesAndPermissions(InfoWorld.Security.Authorization.PolicyAdministrationPoint.User user, List<InfoWorld.Security.Authorization.PolicyAdministrationPoint.Role> roles, string oldUserRole)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateUserRolesAndPermissions(user, roles, oldUserRole);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateUserRolesAndPermissions(user, roles, oldUserRole);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerCacheClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void RefreshCache()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.RefreshCache();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.RefreshCache();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerCacheClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
